/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// SquareHeadedDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "SquareHeadedDlg.h"
#include "section.h"
#include "funcheader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSquareHeadedDlg dialog


CSquareHeadedDlg::CSquareHeadedDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSquareHeadedDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSquareHeadedDlg)
	m_boltLength = 0.0;
	m_boltDiameter = 0.0;
	//}}AFX_DATA_INIT
}


void CSquareHeadedDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSquareHeadedDlg)
	DDX_Text(pDX, IDC_SHBEDIT1, m_boltLength);
	DDV_MinMaxDouble(pDX, m_boltLength, 1.e-005, 1000.);
	DDX_Text(pDX, IDC_SHBEDIT2, m_boltDiameter);
	DDV_MinMaxDouble(pDX, m_boltDiameter, 1.e-004, 1000.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSquareHeadedDlg, CDialog)
	//{{AFX_MSG_MAP(CSquareHeadedDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSquareHeadedDlg message handlers

void CSquareHeadedDlg::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	UpdateData(TRUE);

	if(m_boltLength >0 && m_boltDiameter > 0 ) {
		
		status = CreateSquareHeadedBolt(m_boltLength/1000, m_boltDiameter/1000);
		if(status != 0){
			AfxMessageBox("CreateSquareHeadedBolt failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
